/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import jode.bytecode.BinaryInfo;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.ClassFormatException;
import jode.bytecode.ClassInfo;
import jode.bytecode.ConstantPool;
import jode.bytecode.GrowableConstantPool;

public class MethodInfo
extends BinaryInfo {
    ClassInfo clazzInfo;
    int modifier;
    String name;
    String typeSig;
    BytecodeInfo bytecode;
    String[] exceptions;
    boolean syntheticFlag;
    boolean deprecatedFlag;

    protected void readAttribute(String string, int n, ConstantPool constantPool, DataInputStream dataInputStream, int n2) throws IOException {
        if ((n2 & 0x10) != 0 && string.equals("Code")) {
            this.bytecode = new BytecodeInfo(this);
            this.bytecode.read(constantPool, dataInputStream);
        } else if (string.equals("Exceptions")) {
            int n3 = dataInputStream.readUnsignedShort();
            this.exceptions = new String[n3];
            int n4 = 0;
            while (n4 < n3) {
                this.exceptions[n4] = constantPool.getClassName(dataInputStream.readUnsignedShort());
                ++n4;
            }
            if (n != 2 * (n3 + 1)) {
                throw new ClassFormatException("Exceptions attribute has wrong length");
            }
        } else if (string.equals("Synthetic")) {
            this.syntheticFlag = true;
            if (n != 0) {
                throw new ClassFormatException("Synthetic attribute has wrong length");
            }
        } else if (string.equals("Deprecated")) {
            this.deprecatedFlag = true;
            if (n != 0) {
                throw new ClassFormatException("Deprecated attribute has wrong length");
            }
        } else {
            super.readAttribute(string, n, constantPool, dataInputStream, n2);
        }
    }

    public void read(ConstantPool constantPool, DataInputStream dataInputStream, int n) throws IOException {
        this.modifier = dataInputStream.readUnsignedShort();
        this.name = constantPool.getUTF8(dataInputStream.readUnsignedShort());
        this.typeSig = constantPool.getUTF8(dataInputStream.readUnsignedShort());
        this.readAttributes(constantPool, dataInputStream, n);
    }

    public void reserveSmallConstants(GrowableConstantPool growableConstantPool) {
        if (this.bytecode != null) {
            this.bytecode.reserveSmallConstants(growableConstantPool);
        }
    }

    public void prepareWriting(GrowableConstantPool growableConstantPool) {
        growableConstantPool.putUTF8(this.name);
        growableConstantPool.putUTF8(this.typeSig);
        if (this.bytecode != null) {
            growableConstantPool.putUTF8("Code");
            this.bytecode.prepareWriting(growableConstantPool);
        }
        if (this.exceptions != null) {
            growableConstantPool.putUTF8("Exceptions");
            int n = 0;
            while (n < this.exceptions.length) {
                growableConstantPool.putClassName(this.exceptions[n]);
                ++n;
            }
        }
        if (this.syntheticFlag) {
            growableConstantPool.putUTF8("Synthetic");
        }
        if (this.deprecatedFlag) {
            growableConstantPool.putUTF8("Deprecated");
        }
        this.prepareAttributes(growableConstantPool);
    }

    protected int getKnownAttributeCount() {
        int n = 0;
        if (this.bytecode != null) {
            ++n;
        }
        if (this.exceptions != null) {
            ++n;
        }
        if (this.syntheticFlag) {
            ++n;
        }
        if (this.deprecatedFlag) {
            ++n;
        }
        return n;
    }

    public void writeKnownAttributes(GrowableConstantPool growableConstantPool, DataOutputStream dataOutputStream) throws IOException {
        if (this.bytecode != null) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("Code"));
            dataOutputStream.writeInt(this.bytecode.getSize());
            this.bytecode.write(growableConstantPool, dataOutputStream);
        }
        if (this.exceptions != null) {
            int n = this.exceptions.length;
            dataOutputStream.writeShort(growableConstantPool.putUTF8("Exceptions"));
            dataOutputStream.writeInt(2 + n * 2);
            dataOutputStream.writeShort(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeShort(growableConstantPool.putClassName(this.exceptions[n2]));
                ++n2;
            }
        }
        if (this.syntheticFlag) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("Synthetic"));
            dataOutputStream.writeInt(0);
        }
        if (this.deprecatedFlag) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("Deprecated"));
            dataOutputStream.writeInt(0);
        }
    }

    public void write(GrowableConstantPool growableConstantPool, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.modifier);
        dataOutputStream.writeShort(growableConstantPool.putUTF8(this.name));
        dataOutputStream.writeShort(growableConstantPool.putUTF8(this.typeSig));
        this.writeAttributes(growableConstantPool, dataOutputStream);
    }

    public void dropInfo(int n) {
        if ((n & 0x10) != 0) {
            this.bytecode = null;
            this.exceptions = null;
        }
        if (this.bytecode != null) {
            this.bytecode.dropInfo(n);
        }
        super.dropInfo(n);
    }

    public ClassInfo getClazzInfo() {
        return this.clazzInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.typeSig;
    }

    public int getModifiers() {
        return this.modifier;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifier);
    }

    public boolean isSynthetic() {
        return this.syntheticFlag;
    }

    public boolean isDeprecated() {
        return this.deprecatedFlag;
    }

    public BytecodeInfo getBytecode() {
        return this.bytecode;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(String string) {
        this.typeSig = string;
    }

    public void setModifiers(int n) {
        this.modifier = n;
    }

    public void setSynthetic(boolean bl) {
        this.syntheticFlag = bl;
    }

    public void setDeprecated(boolean bl) {
        this.deprecatedFlag = bl;
    }

    public void setBytecode(BytecodeInfo bytecodeInfo) {
        this.clazzInfo.loadInfo(16);
        this.bytecode = bytecodeInfo;
    }

    public void setExceptions(String[] stringArray) {
        this.clazzInfo.loadInfo(16);
        this.exceptions = stringArray;
    }

    public String toString() {
        return "Method " + Modifier.toString(this.modifier) + " " + this.typeSig + " " + this.clazzInfo.getName() + "." + this.name;
    }

    public MethodInfo(ClassInfo classInfo) {
        this.clazzInfo = classInfo;
    }

    public MethodInfo(ClassInfo classInfo, String string, String string2, int n) {
        this.clazzInfo = classInfo;
        this.name = string;
        this.typeSig = string2;
        this.modifier = n;
    }
}

